package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.ad.ADQueryResult;
import gov.va.med.mhv.sm.dao.SignatureDao;
import gov.va.med.mhv.sm.enumeration.EmailNotificationEnum;
import gov.va.med.mhv.sm.enumeration.MessageFilterEnum;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.PerformerTypeEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Signature;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.AdminService;
import gov.va.med.mhv.sm.service.LoggingService;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.util.XSSWrapperUtils;
import gov.va.med.mhv.sm.web.form.AssignSurrogates;
import gov.va.med.mhv.sm.web.form.StaffOrTriageVO;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


public class Preferences extends AbstractInboxAction  {
	private static final Log log = LogFactory.getLog(Preferences.class);
	public static final String SURROGATES = "SURROGATES";
	public static final String STAFFANDTRIAGE = "STAFFANDTRIAGE";
	private HttpServletRequest request;
	private String STRUTS_RESULT;
	private User user;
	private UserManagementService userManagementService;
	private AdminService adminService;
	private TriageGroupService triageGroupService;
	private LoggingService loggingService;
	private SignatureDao signatureDao;
	private String preferencesForm;
	private MailboxService mailboxService;
	private String surrogateTurnOff;
	private String signatureName;
	private String signatureTitle;
	private String signatureInclude;
	private String apply;

	private final String SURROGATE_SETUP_MESSAGE="Your surrogate(s) have been successfully saved";
	public static String SURROGATE_DEFAULT_VALUE = "-- Select a Staff/Triage Group --";
	private AssignSurrogates[] assignSurrogates = new AssignSurrogates[5];
	
	public Preferences()
	{
		super();
	}

	public void setServletRequest(HttpServletRequest httpServletRequest)
	{
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public void prepare() throws Exception
	{
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
									.getWebApplicationContext(ServletActionContext
									.getServletContext());
		userManagementService = (UserManagementService) ctx.getBean("userManagementService");
		adminService = (AdminService)ctx.getBean("adminService");
		loggingService = (LoggingService) ctx.getBean("loggingService");
		try{preferencesForm=request.getParameter("PreferencesForm");}catch(Exception e){preferencesForm="";}
		user=(User)request.getSession().getAttribute(CURRENT_USER);
		STRUTS_RESULT = user.getUserType() == UserTypeEnum.PATIENT ? "PATIENT":"CLINICIAN";
		triageGroupService = (TriageGroupService)ctx.getBean("triageGroupService");
		mailboxService = (MailboxService) getBean("mailboxService");
		signatureDao = (SignatureDao)getBean("signatureDao");
		loadUserSignature();
		
		//Initialize assignsurrogates to have empty objects.
		for( int i = 0; i < assignSurrogates.length; i++ ) {
			assignSurrogates[i] = new AssignSurrogates();
		}
	}

	public String clinicianPreferencesInboxView()
	{
		MessageFilterEnum mfe=MessageFilterEnum.ALL;
		String FilterIs="All";
		try
		{ 
			FilterIs=request.getParameter("clinicianPreferencesInboxViewType");
			
		}catch(Exception e)
		{
			FilterIs="All";
		}
		
		if(FilterIs.equals("0")){mfe=MessageFilterEnum.ALL;}
		if(FilterIs.equals("1")){mfe=MessageFilterEnum.ASSIGNED_TO_ME;}
		if(FilterIs.equals("2")){mfe=MessageFilterEnum.UNASSIGNED;}
		
		Folder currentFolder = getCurrentFolder();
		currentFolder.setFilter(mfe);
		mailboxService.getMessages(currentFolder, MessagesPageEnum.FIRST);
		//Make sure to refresh the Session instance of the Folder
		// (The counts may have been updated because of the current filter)
		setCurrentFolder(currentFolder);
		
		user.setMessageFilter(mfe);
		userManagementService.savePreferences(user);
		loggingService.clinicianInboxViewChanges(user, PerformerTypeEnum.SELF, "Inbox View:"+mfe.getName(),true);
		setCurrentUser(user);
		
		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			loadSurrogates();	
		}
		
		return STRUTS_RESULT;
	}

	public String participationStatusPreferences()
	{
		return "OPTIN";
	}

	/*
	 * loadUserSignature() method loads the user signature object and display the value signature name, title, include Signature block to UI.
	 */
	private void loadUserSignature(){
		List signatureDaoList  =  signatureDao.getSignatureForUser(user.getId());
		Signature signature = null; 
		if(signatureDaoList!=null && signatureDaoList.size() >0){
			signature = (Signature)signatureDaoList.get(0);
			setSignatureName(StringEscapeUtils.unescapeHtml(signature.getName()));
			setSignatureTitle(StringEscapeUtils.unescapeHtml(signature.getTitle()));
			setSignatureInclude(""+signature.isActive());
		}
		signatureDaoList=null;
		signature = null;
	}
	
	/*
	 *  method userSignatureBlock() used to collect the request object from UI and
	 *  make the desicion either to persist the Signature record or update the Signature record.
	 */
	public String userSignatureBlock(){
		ServiceResponse<Boolean> response = null;

		Signature signature = null;
		
		if(signatureInclude.equals("true")){
			if(signatureName.length()<=0 || signatureTitle.length() <=0){
 				 this.addFieldError("userSignatureForm", "Please enter Name and Title");
				 return STRUTS_RESULT;
			}
		}
		List signatureDaoList  =  signatureDao.getSignatureForUser(user.getId());
		if(signatureDaoList !=null && signatureDaoList.size() > 0){
			signature = (Signature)signatureDaoList.get(0);
			signature.setModifiedDate(new Date());
			
		}
		else
		{
			signature = new Signature();
			signature.setCreatedDate(new Date());
		}
		signature.setUser(user);
		signature.setTitle(StringEscapeUtils.escapeHtml(signatureTitle));
		signature.setName(StringEscapeUtils.escapeHtml(signatureName));
		if(signatureInclude.equals("true"))
			signature.setActive(true);
		else
			signature.setActive(false);

		response = userManagementService.addUserSignature(signature);
		loggingService.userSignatureChanges(user, PerformerTypeEnum.SELF, "Signature Include?:"+signature.isActive()+" :"+signature.getName()+" ,"+signature.getTitle(),true);		
	    this.addFieldError("userSignatureForm", "Changes saved.");
	    if(!response.getPayload().booleanValue()){
	    	this.addFieldError("userSignatureForm","An Error as occured while save the signature");
	    }
	    response = null;
	    signatureDaoList = null;
	    signature = null;
	    
	    if(user.getUserType() == UserTypeEnum.CLINICIAN){
	    	loadSurrogates();	
	    }
	    return STRUTS_RESULT;
	}
	
	public String assignNotificationPreferences()
	{
		//Email address
		String newMsgNotifEmailIs="Enter an Email Address";
		try{newMsgNotifEmailIs=request.getParameter("newMsgNotif_EMAILADDRESS");}catch(Exception e){newMsgNotifEmailIs="Enter an Email Address";}
		
		newMsgNotifEmailIs = (newMsgNotifEmailIs == null)?"":StringEscapeUtils.escapeHtml(newMsgNotifEmailIs.trim());
		
		if((newMsgNotifEmailIs.equalsIgnoreCase("Enter an Email Address")) || (newMsgNotifEmailIs.equals("")))
		{
			// The Following condition has been implmented for part of CR#4652(Clinician must have valid email Address)
			if(user.getUserType() == UserTypeEnum.CLINICIAN)			 
			{
				user.setEmail("");
				this.addFieldError("notificationForm","Email Address cannot be blank.");
				return STRUTS_RESULT;
			}
			else
			{
				user.setEmail(null);
			}	
		}else if ( validateEmailAddress(newMsgNotifEmailIs) )
		{
			user.setEmail(newMsgNotifEmailIs);
		} 
		else
		{
			this.addFieldError("notificationForm", newMsgNotifEmailIs + " is not a valid email address.");
			return STRUTS_RESULT;
		}

		//Email Notification Status
		String EmailNotificationStatus="None";
		EmailNotificationEnum enm=EmailNotificationEnum.NONE;
		try{EmailNotificationStatus=request.getParameter("newMsgNotif_NOTIFY");}catch(Exception e){EmailNotificationStatus="None";}
		if(EmailNotificationStatus.equals("None")               ){enm=EmailNotificationEnum.NONE;}
		if(EmailNotificationStatus.equals("Each message")       ){enm=EmailNotificationEnum.EACH_MESSAGE;}
		if(EmailNotificationStatus.equals("Once daily")         ){enm=EmailNotificationEnum.ONE_DAILY;}
		if(user.getUserType() == UserTypeEnum.CLINICIAN){
		  if(EmailNotificationStatus.equals("On assignment to me")){enm=EmailNotificationEnum.ON_ASSIGNEMNT;}
		}
		user.setEmailNotification(enm);
		userManagementService.savePreferences(user);
		loggingService.notificationPreferenceChange(user, PerformerTypeEnum.SELF, "Notify Me:"+user.getEmailNotification().getName()+", Email address:"+user.getEmail(),true);
		this.addFieldError("notificationForm", "Changes saved.");
		
		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			loadSurrogates();
		}
		return STRUTS_RESULT;
	}
	
	public static boolean validateEmailAddress(String email){
		EmailValidator emailValidator = EmailValidator.getInstance();
		return emailValidator.isValid(email);
	}
	
	private List<Surrogate> defaultSurrogates(int size) {
		List<Surrogate> list = new ArrayList<Surrogate>();
		for(int i = 0; i < size; i++) {
			Surrogate s = new Surrogate();
			s.setActive(false);
			Date today = new Date();
			s.setSurrogateStartDate(today);
			s.setSurrogateEndDate(today);
			s.setSurrogateAllDay(true);
			list.add(s);
		}
		return list;
	}
	
	@SuppressWarnings("unchecked")
	public String viewPreferences()
	{
		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			Clinician c = (Clinician)user;
		
			/*CR#4651 Implementation starts here-clinician emailId should be pre-populated from Active Directory*/
			if(user.getEmail()==null || user.getEmail().equals("")){
				ServiceResponse<ADQueryResult> adQueryResponse = adminService.findADAccount(user.getUsername());
				ADQueryResult adQueryResult = adQueryResponse.getPayload();
				if(adQueryResult !=null){
					if(adQueryResult.getEmail()!=null || adQueryResult.getEmail()!=""){
						request.getSession().setAttribute("adQueryEmailAddress",adQueryResult.getEmail());
					}
				}
			}
	    	/*CR#4651 Implementation ends here*/
			
			//Prepare the list of clinicians and staff
			loadStaffAndTriageList(c);
			loadSurrogates();
		}
		return STRUTS_RESULT;
	}
	
	private void loadSurrogates() {
		Clinician c = (Clinician)user;
//		Retrieve the current surrogates
		CollectionServiceResponse<Surrogate> surrResp = userManagementService.getSurrogatesFor(c);
		List<Surrogate> surrogates = (List)surrResp.getCollection();
		
		if( surrogates.size() < 5 ) {
			//Setup EMPTY Surrogate objects  (Don't associate them with the user yet)
			List<Surrogate> emptySurrogates = defaultSurrogates(5-surrogates.size());
			//Merge the two sets
			surrogates.addAll(emptySurrogates);
		}
		
		List<AssignSurrogates> assignSurrogates = new ArrayList<AssignSurrogates>();
		for( Surrogate s1: surrogates ) {
			AssignSurrogates s = AssignSurrogates.createAssignSurrogate(s1);
			
			//Convert the Id into a named element for the select
			if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN)) {
				ServiceResponse<Clinician> clinResp = userManagementService.fetchClinician(s.getSurrogateId());
				Clinician clin = clinResp.getPayload();
				
				s.setStaffOrTriageValue(StaffOrTriageVO.getClinicianValueForId(clin.getId()));
			}
			else if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)) {
				ServiceResponse<TriageGroup> triageResp = triageGroupService.findTriageGroupById(s.getSurrogateId());
				TriageGroup tg = triageResp.getPayload();
				s.setStaffOrTriageValue(StaffOrTriageVO.getTriageGroupValueForId(tg.getId()));
			} else {
				//Use a default value
				s.setStaffOrTriageValue(SURROGATE_DEFAULT_VALUE);
			}
			assignSurrogates.add(s);
		}
		request.setAttribute(SURROGATES, assignSurrogates);
		
		//Prepare the list of clinicians and staff
		loadStaffAndTriageList(c);

	}
	
	
	public String assignSurrogates() {
		//make sure they didn't select a default value for a surrogate use SURROGATE_DEFAULT_VALUE
		Clinician c = (Clinician)user;
		
		loadStaffAndTriageList(c);
		
		//Verify that form array is not null
		List<AssignSurrogates> list = new ArrayList<AssignSurrogates>();
		for(int i = 0; i < assignSurrogates.length; i++) {
			AssignSurrogates s = assignSurrogates[i];
			//Convert the Id into a named element for the select
			if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN)) {
				ServiceResponse<Clinician> clinResp = userManagementService.fetchClinician(s.getSurrogateId());
				Clinician clin = clinResp.getPayload();
				s.setStaffOrTriageValue(StaffOrTriageVO.getClinicianValueForId(clin.getId()));
			}
			else if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)) {
				ServiceResponse<TriageGroup> triageResp = triageGroupService.findTriageGroupById(s.getSurrogateId());
				TriageGroup tg = triageResp.getPayload();
				s.setStaffOrTriageValue(StaffOrTriageVO.getTriageGroupValueForId(tg.getId()));
			} else {
				//Use a default value
				s.setStaffOrTriageValue(SURROGATE_DEFAULT_VALUE);
			}
			list.add(s);
		}
		request.setAttribute(SURROGATES, list);
		
		int count = 0;
		for(AssignSurrogates cs:list) {
			if( cs.getId() != null && !cs.getId().equals(SURROGATE_DEFAULT_VALUE) ) {
				String errorParam = "assignSurrogatesForm";
				String errorRow = " for row " + (count+1);
				
//				Validate required fields
				if(!cs.getId().contains("|")) {
					this.addFieldError(errorParam, "Please select a valid staff or triage name" + errorRow);
					return STRUTS_RESULT;
				}
				
				
				
				if(cs.getStartDate() == null || cs.getStartDate().length() == 0) {
					this.addFieldError(errorParam, "Please select a valid start date" + errorRow);
					return STRUTS_RESULT;
				}
				
				if(cs.getEndDate() == null || cs.getEndDate().length() == 0) {
					this.addFieldError(errorParam, "Please select a valid end date" + errorRow);
					return STRUTS_RESULT;
				}
				
				try {
					if( cs.getStartDate() != null && cs.getStartDate().length()!=0) {
						Date tempSurrogateStartDate = new Date();
						tempSurrogateStartDate =(DateUtils.parseDateNoLeniency(cs.getStartDate(), DateUtils.ENGLISH_DATE_FORMAT));
					}
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid start date"+errorRow);
					return STRUTS_RESULT;
				}
				
				try {
					if( cs.getEndDate() != null && cs.getEndDate().length()!=0) {
						Date tempSurrogateStartDate = new Date();
						tempSurrogateStartDate =(DateUtils.parseDateNoLeniency(cs.getEndDate(), DateUtils.ENGLISH_DATE_FORMAT));
					}
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid end date"+ errorRow);
					return STRUTS_RESULT;
				}
				
				
				
//				Validate date ranges
				try {
					cs.getStartDateTime();
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid start date and time" + errorRow);
					return STRUTS_RESULT;
				}
				
				try {
					cs.getEndDateTime();
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid end date and time" + errorRow);
					return STRUTS_RESULT;
				}
				
				
				try {
					if( cs.getStartDateTime().after(cs.getEndDateTime()) ) {
						this.addFieldError(errorParam, "Please verify that the From date is before To date" + errorRow);
						return STRUTS_RESULT;
					}
				} catch (ParseException e) {
					//Caught and handled prior to this call
				}
				
				try{
					if(cs.getStartDate().equals(cs.getEndDate())){
						//System.out.println("Both dates are same....");
						if(cs.getStartDateTime().equals(cs.getEndDateTime())){
							this.addFieldError(errorParam, "The From Date and Time cannot be the same as the To Date and Time" + errorRow);
							return STRUTS_RESULT;
						}
						
				}
				}catch(Exception e){}
					
				
				
				
			}
			count++;
		}
		
//		Check for overlapping dates
		
		//sort collection by start date  and only check for overlaps on rows that have data.
		List<AssignSurrogates> list2 = new ArrayList<AssignSurrogates>();
		for(AssignSurrogates a: list) {
			if( a.getSurrogateType() != null ) {
				list2.add(a);
			}
		}
		Collections.sort(list2, AssignSurrogates.ASSIGN_SURROGATES_SORTER);
		AssignSurrogates curr = null;
		for(AssignSurrogates a: list2) {
			try {
				//!curr.getEndDateTime().equals(a.getStartDateTime())
				if( curr != null && curr.getEndDateTime().after(a.getStartDateTime())) {
					this.addFieldError("assignSurrogatesForm", "Please verify that there are no overlapping start dates and end dates");
					return STRUTS_RESULT;
				} else {
					curr = a;
				}
			} catch (ParseException e) {
				//Ignore already caught and handled prior to this validation
			}
		}
		
		//Now that all validation passed go ahead and save the data.
		
		List<Surrogate>saveSurrogates = new ArrayList<Surrogate>();
		for(AssignSurrogates a: list2) {
			if( a.getSurrogateType() != null ) {
				Surrogate s = new Surrogate();
				s.setSurrogateId(a.getSurrogateId());
				s.setSurrogateAllDay(a.getAllDayBool());
				try {
					s.setSurrogateEndDate(a.getEndDateTime());
					s.setSurrogateStartDate(a.getStartDateTime());
				} catch (ParseException e) {
					//Ignore validation already done
				}
				s.setSurrogateType(a.getSurrogateType());
				saveSurrogates.add(s);
			}
		}
		ServiceResponse<Boolean> clearResp = userManagementService.clearSurrogatesFor(c);
		handleMessages(clearResp);
		if( !clearResp.getPayload() ) {
			addFieldError("assignSurrogatesForm", "Error clearing existing surrogates");
			return STRUTS_RESULT;
		}
		
		ServiceResponse<Boolean> clinResp = userManagementService.setSurrogatesFor(c,saveSurrogates);
		handleMessages(clinResp);
		if( !clinResp.getPayload() ) {
			addFieldError("assignSurrogatesForm", "Error saving surrogates");
			return STRUTS_RESULT;
		}
		
		addFieldError("assignSurrogatesForm", SURROGATE_SETUP_MESSAGE);
		
		loadSurrogates();
		
		return STRUTS_RESULT;
	}
	
	private void loadStaffAndTriageList(Clinician c) {
		CollectionServiceResponse<Clinician> response1 = userManagementService.getCliniciansForStation(c.getStationNo());
		Collection<Clinician> clinicians = response1.getCollection();
		CollectionServiceResponse<TriageGroup> response2 = triageGroupService.getTriageGroupsForStation(c.getStationNo());
		Collection<TriageGroup> tGroups = response2.getCollection();
		
		// Exclude the logged in Clinician from the list.
		Clinician remove = null;
		for(Clinician c1: clinicians) {
			if( c1.getId().equals( user.getId() )) {
				remove = c1;
				break;
			}
		}
		if( remove != null )
			clinicians.remove(remove);
		
		List<StaffOrTriageVO> allPickList = StaffOrTriageVO.createFolderVOList( clinicians, tGroups );
		getRequest().setAttribute(STAFFANDTRIAGE, allPickList);
	}
	
	
	public String changeSurrogateStatus()
	{
		if((surrogateTurnOff != null) && (surrogateTurnOff.equalsIgnoreCase("yes"))){
			if(log.isInfoEnabled()){
				log.info("surrogateTurnOff Val: isYes: " + surrogateTurnOff.toString());
			}
			Long surrogateId = (Long)request.getSession().getAttribute("SURROGATE_ID_TO_REMOVE");
			ServiceResponse<Boolean> response = userManagementService.removeSurrogate(surrogateId);
			request.getSession().setAttribute("SURROGATE_ID_TO_REMOVE",null);
			getRequest().getSession().setAttribute("currentSurrogate", null);
		}
		else
		{
			if(log.isInfoEnabled()){
				log.info("surrogateTurnOff Val: isYes: " + surrogateTurnOff.toString());
			}
		}
		return STRUTS_RESULT;
	}
	
	public void setPreferencesForm(String preferencesForm) {
		this.preferencesForm = preferencesForm;
	}

	public String getSignatureName() {
		return signatureName;
	}

	public void setSignatureName(String signatureName) {
		this.signatureName = signatureName;
	}

	public String getSignatureTitle() {
		return signatureTitle;
	}

	public void setSignatureTitle(String signatureTitle) {
		this.signatureTitle = signatureTitle;
	}

	public String getSignatureInclude() {
		return signatureInclude;
	}

	public void setSignatureInclude(String signatureInclude) {
		this.signatureInclude = signatureInclude;
	}

	public String getApply() {
		return apply;
	}

	public void setApply(String apply) {
		this.apply = apply;
	}

	public LoggingService getLoggingService() {
		return loggingService;
	}

	public void setLoggingService(LoggingService loggingService) {
		this.loggingService = loggingService;
	}
	
	public AssignSurrogates[] getAssignSurrogates() {
		return assignSurrogates;
	}

	public String getSurrogateTurnOff() {
		return surrogateTurnOff;
	}

	public void setSurrogateTurnOff(String surrogateTurnOff) {
		this.surrogateTurnOff = surrogateTurnOff;
	}
}
